﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Neurons;
using Neurons.NNLayers;

namespace NNControl.NNTraining
{
    public partial class OutputLayerForm : Form
    {
        OutputLayer layer;
        Layer preLayer;
        List<Char> outputLetters;
        bool isUnknownOutput;
        public bool IsUnknownOutput
        {
            get
            {
                return isUnknownOutput;
            }
           
        }
        public List<Char> OutputLetters
        {
            get
            {
                return outputLetters;
            }
        }
        public OutputLayer Layer
        {
            get
            {
                return layer;
            }
        }
        public OutputLayerForm(Layer prelayer)
        {
            InitializeComponent();
            layer = null;
            preLayer = prelayer;
            outputLetters = null;
        }

        private void btAdd_Click(object sender, EventArgs e)
        {
            if (GetOutputLetters(tbOutputLetters.Text))
            {
                string label = tbLabel.Text;
                int nNeurons = (int)outputLetters.Count;
                isUnknownOutput = cbUnknownOutput.Checked;
                layer = new OutputLayer(label, preLayer, nNeurons, cbUnknownOutput.Checked);
                layer.Initialize();
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            else
            {
                MessageBox.Show("Error in output letter string!", "Output letters String error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        /// <summary>
        /// Get output letter to a neural network
        /// </summary>
        /// <param name="text">output letter string</param>
        bool GetOutputLetters(String text)
        {
            if (outputLetters != null)
            {
                outputLetters = null;
            }
            outputLetters = new List<char>();
            try
            {
                string temp = text;
                while (true)
                {
                    int index = temp.IndexOf(',');
                    if (index > 0)
                    {
                        string character = temp.Substring(0, index).Trim();
                        Char c = Convert.ToChar(character);
                        outputLetters.Add(c);
                        temp = temp.Substring(index + 1).Trim();
                    }
                    else
                    {
                        if (temp.Length > 0)
                        {
                            Char c = Convert.ToChar(temp.Trim());
                            outputLetters.Add(c);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex)
            {
                return false;
            }
            return true;
        }
    }
}
